/*
 * CONVERT BETWEEN 2'S COMPLEMENT AND UNSIGNED SAMPLE FORMAT
 *
 * Version 1.00 -- 3/21/93 by Royce Liao
 * Adapted from CHARCNT.C (Learn C Now! compiler)
 *                         Microsoft Press  (C) Microsoft
 */

/* Description-- Convert data samples between 2's complement and normal.
   I wrote this program to practice my C programming skills.  I'm pretty
   sure there are plenty of programs that out-perform this code segment
   (and with a much better user interface.)

   I don't have access to a *REAL* compiler (unless I count EMX-0.8f/
   GCC/2 2.2.2 for OS/2 2.0, which I can't get to work anyway.)

   2S.C will convert between UNSIGNED and 2'S COMPLEMENT format
   This program is intended for the GRAVIS ULTRASOUND's .SND format
   This program will NOT work with .WAV or .VOC, or any file with
   a header containing non-sample information

   This program WILL work with 8-bit or 16-bit files. It is un-important
   whether these files are stereo or mono.

   2S.C wird umtauscht zwischen UNSIGNED und 2'S COMPLEMENT.
   Sie sollen diese Program mit ULTRASOND benutzen.  Es wird funktioniert
   nicht beim .WAV oder .VOC weil die "Header" Information des Anfangt
   kaputt wird gewesn.

   Diese Program soll bei 8 oder 16 bit Filen arbeiten.  Stereo und Mono
   sind unwichtig.

   Yes, I'm not a native speaker of German.  Sorry */

#include <\work\lc\include\stdio.h>
#include <\work\lc\include\stdlib.h>     /* for exit() prototype */

#define MAXPATH 64
#define BUF_SIZE 512

main(void)
{
	int flag16;  /* if flag16=1 (true), if flag16=0 (false) */
	int loop,n;
	FILE *fpin, *fpout;               /* file pointer */
	char pathname[MAXPATH]; /* filename */
	char outpath[MAXPATH+4];
	char in_buffer[BUF_SIZE];  /* character buffer */
	char ch;
	long charcnt=0, skip=0;   /* counter and offset */
	/*
	 * Prompt the user for a filename and read it.
	 */

	printf("\nFilename: ");
	scanf("%s",pathname);

	fpin = fopen(pathname, "rb");
	if (fpin == NULL) {
		fprintf(stderr, "Cannot open %s\n", pathname);
		exit(1);
	}

	printf("\nOutpath: ");
	scanf("%s",outpath);

	do {
	   printf("\n16-bit file? (y/n) ");
	   scanf("%c",&ch);
	   switch (ch) {
	     case 'Y': case 'y':
		flag16=1; break;
	     case 'N': case 'n':
		flag16=0; break;
	     default:
		flag16=-1; break; }
	   }
	while (flag16==-1);

	printf("\nSkip how many characters or 0 ? ");
	scanf("%ld",&skip);
	if (skip!=0)
	   if (fseek(fpin,skip,SEEK_SET) != 0)   {
		printf("\nWARNING!  Could not seek to %ld!",skip);
		charcnt=0-skip;
		}

	printf("\nchanging between 2's complement and Unsigned.");
	printf("\nJetzt umkehrt zwischen 2's Complement und Unsigned.");
	if (flag16==1)
	   printf("\n16-bit mode");

	fpout=fopen(outpath, "wb");

	/*
	 * Read the contents of the file and increment the
	 * character count as each character is read.
	 */
	charcnt+=skip; /* precompensate counter */

	do
		{
		n=fread(in_buffer,sizeof(char),BUF_SIZE,fpin);
		if (flag16==1)
		   for (loop=1; loop<n; loop+=2) /* Convert 16-bit data */
			in_buffer[loop]-=128;
		  else
		   for (loop=0; loop<n;++loop)   /* Convert  8-bit data */
			in_buffer[loop]-=128;

		fwrite(in_buffer,sizeof(char),n,fpout);
		charcnt+=n;
		}
	while (n==BUF_SIZE);

	if (ferror(fpin) != 0) {
		fprintf(stderr, "Error reading %s\n", pathname);
		exit(2);
	}

	/*
	 * Report the filename and character count
	 * and close the file.
	 */
	printf("\nFile %s contains %ld samples.\n",
		pathname, charcnt);
	if (fclose(fpin) != 0) {
		fprintf(stderr, "Error closing %s\n",
			pathname);
		exit(3);
	}
	if (fclose(fpout) !=0) {
		fprintf(stderr, "Error closing %s\n",
			outpath);
		exit(3);
	}

	return (0);
}

/* Not sure how I'd use the exit codes. Feel free to distribute this
   program, but remember that some code was originally from the LEARN_C NOW
   package from Microsoft Press.  */
/* I am working on a utility/utilities to split a stereo file into 2 mono
   files...and vice versa. */

/* END OF FILE */
